import 'package:flutter/material.dart';

import 'package:provider/provider.dart';

import '../../providers/phonepe_base.dart';
import '../../services/di/locator.dart';

class BaseView<T extends BaseModel> extends StatefulWidget {
  const BaseView({super.key, required this.builder, this.onModelReady});
  final Widget Function(BuildContext context, T model, Widget? child) builder;
  final Function(T)? onModelReady;

  @override
  // ignore: library_private_types_in_public_api
  _BaseViewState<T> createState() => _BaseViewState<T>();
}

class _BaseViewState<T extends BaseModel> extends State<BaseView<T>> {
  T model = locator<T>();

  @override
  void initState() {
    if (widget.onModelReady != null) {
      widget.onModelReady!(model);
    }
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return ChangeNotifierProvider<T>.value(
      value: model,
      child: Consumer<T>(builder: widget.builder),
    );
  }
}
